<?php
session_start();
define('SR_DENIED', true);
if (!include ("config.inc.php")) { die("Не найден рабочий файл конфигурации"); exit; }

// Generate a more secure captcha
$length = $spamcontrol_length;
$chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz23456789';
$captcha = '';
for ($i = 0; $i < $length; $i++) {
    $captcha .= $chars[mt_rand(0, strlen($chars) - 1)];
}

// Create image
$width = 120;
$height = 40;
$img = imagecreate($width, $height);

// Allocate colors
$bg_color = trim($LIGHT);
$bg3 = hexdec(substr($bg_color, -2));
$bg2 = hexdec(substr($bg_color, -4, 2));
$bg1 = hexdec(substr($bg_color, -6, 2));
$bg = imagecolorallocate($img, $bg1, $bg2, $bg3);

$font_color_a = trim($spamcontrol_color);
$font_color_a3 = hexdec(substr($font_color_a, -2));
$font_color_a2 = hexdec(substr($font_color_a, -4, 2));
$font_color_a1 = hexdec(substr($font_color_a, -6, 2));
$font_color = imagecolorallocate($img, $font_color_a1, $font_color_a2, $font_color_a3);

// Add some random lines for noise
for($i = 0; $i < 5; $i++) {
    $line_color = imagecolorallocate($img, mt_rand(0, 100), mt_rand(0, 100), mt_rand(0, 100));
    imageline($img, mt_rand(0, $width), mt_rand(0, $height), mt_rand(0, $width), mt_rand(0, $height), $line_color);
}

// Add some random dots for noise
for($i = 0; $i < 50; $i++) {
    $dot_color = imagecolorallocate($img, mt_rand(0, 150), mt_rand(0, 150), mt_rand(0, 150));
    imagesetpixel($img, mt_rand(0, $width), mt_rand(0, $height), $dot_color);
}

// Draw the captcha text with basic distortion
$font_size = 5;
$x_offset = 10;
for ($i = 0; $i < strlen($captcha); $i++) {
    $y_pos = mt_rand(15, 25);
    $char = $captcha[$i];
    $text_color = imagecolorallocate($img, mt_rand(0, 100), mt_rand(0, 100), mt_rand(0, 100));
    imagechar($img, $font_size, $x_offset, $y_pos, $char, $text_color);
    $x_offset += imagefontwidth($font_size) + 2;
}

// Store captcha in session
$_SESSION["antispam"] = $captcha;

// Output image
header("Content-Type: image/png");
imagepng($img); 
imagedestroy($img);
?> 